module net.BurtonRadons.spyl.value;

/** A value object. */
class Value
{
    /** Return the name of the type this value is. */
    abstract char [] typeName ();
    
    /** Return repr. */
    final char [] toString ()
    {
        return repr ();
    }
    
    /** Call the value as a function.  The default throws an error. */
    Value call (Value [] arguments)
    {
        throw new Error (typeName () ~ " cannot be called.");
        return null;
    }
    
    /** Return a string representation of the object.  The default returns repr. */
    char [] str ()
    {
        return toString ();
    }
    
    /** Return a reversible representation of the object.  This means that it should be
      * as close to an input string as possible; if it can't be such, then the result
      * should be surrounded in double angle brackets.
      */
      
    abstract char [] repr ();
    
    /** Call this as a function with no arguments if it is an attribute, or return this. */
    Value expand ()
    {
        return this;
    }
    
    Value do_doc () { return new StringValue (doc ()); }
    
    /** Return a named attribute.  The default throws an error. */
    Value getattr (char [] name)
    {
        switch (name)
        {
            case "doc": return new AttributeFunctionValue (&do_doc, "A self-documentation std.string.");
            default: throw new Error (typeName () ~ " does not have an attribute named " ~ name ~ ".");
        }
    }
    
    /** Index as an array.  The default casts to integer and calls the second-form getitem. */
    Value getitem (Value index)
    {
        index = index.castTo (IntegerType.create ());
        return getitem (((IntegerValue) index).content);
    }
    
    /** Index as an array.  The default throws an error. */
    Value getitem (int index)
    {
        throw new Error (typeName () ~ " cannot be indexed through getitem ().");
        return null;
    }
    
    /** Slice as an array.  The default throws an error. */
    Value getslice (Value min, Value max)
    {
        throw new Error (typeName () ~ " cannot be indexed through getslice ().");
        return null;
    }
    
    Value opAdd (Value b)
    {
        return b.add_r (this);
    }
    
    Value add_r (Value b)
    {
        throw new Error (b.typeName () ~ ".add (" ~ typeName () ~ ") is not implemented.");
        return null;
    }
    
    Value opSub (Value b)
    {
        return b.sub_r (this);
    }
    
    Value opSub_r (Value b)
    {
        throw new Error (b.typeName () ~ ".sub (" ~ typeName () ~ ") is not implemented.");
        return null;
    }
    
    Value opMul (Value b)
    {
        return b.mul_r (this);
    }
    
    Value mul_r (Value b)
    {
        throw new Error (b.typeName () ~ ".mul (" ~ typeName () ~ ") is not implemented.");
        return null;
    }
    
    /** Exponentiation operator; "this ** other". */
    Value opPow (Value b)
    {
        return b.pow_r (this);
    }
    
    Value opPow_r (Value b)
    {
        throw new Error (b.typeName () ~ ".pow (" ~ typeName () ~ ") is not implemented.");
        return null;
    }
    
    Value opNeg ()
    {
        throw new Error (typeName () ~ ".neg () is not implemented.");
        return null;
    }
    
    Value opCat (Value b)
    {
        return b.cat_r (this);
    }
    
    Value opCat_r (Value b)
    {
        throw new Error (b.typeName () ~ ".cat (" ~ typeName () ~ ") is not implemented.");
        return null;
    }
    
    Value opCatAssign (Value b)
    {
        throw new Error ("operator (" ~ typeName () ~ " ~= " ~ b.typeName () ~ ") is not implemented.");
        return null;
    }
    
    /** Return a documenting string describing the value.  The default throws an error. */
    char [] doc ()
    {
        throw new Error (typeName () ~ ".doc is not implemented.");
        return null;
    }
    
    /** Attempt to cast to a different type, returning the result. */
    Value castTo (Value resultType)
    {
        throw new Error (typeName () ~ " cannot be casted to " ~ resultType.typeName () ~ ".");
        return null;
    }
}

import net.BurtonRadons.spyl.valueArray;
import net.BurtonRadons.spyl.valueBoolean;
import net.BurtonRadons.spyl.valueFloat;
import net.BurtonRadons.spyl.valueFunction;
import net.BurtonRadons.spyl.valueInteger;
import net.BurtonRadons.spyl.valueNull;
import net.BurtonRadons.spyl.valueString;

private import net.BurtonRadons.spyl.scope;
